
# https://wiki.scribus.net/canvas/Adjust_a_text_frame_to_fit_its_content

class TextFrame:

	def __init__(self,scribus,name):
		self.scribus = scribus
		self.name = name
		self.w , self.h = self.scribus.getSize(self.name)

	def setText(self,text):
		self.scribus.setText(text,self.name)
		self.scribus.setParagraphStyle("Info Paragraph Style",self.name)

	def resizeHeight(self,dh):
		self.h+=dh;
		self.scribus.sizeObject(self.w,self.h,self.name);

	def setHeight(self,h):
		self.h=h;
		self.scribus.sizeObject(self.w,self.h,self.name);

	def frameEnlarge(self):
		print("### frameEnlarge:",self.name)
		while( 1 == self.scribus.textOverflows(self.name)): self.resizeHeight(  1.00 )
		while( 0 == self.scribus.textOverflows(self.name)): self.resizeHeight( -0.10 )
		while( 1 == self.scribus.textOverflows(self.name)): self.resizeHeight(  0.01 )

	def frameShrink(self):
		print("### frameShrink:",self.name)
		while( 0 == self.scribus.textOverflows(self.name)): self.resizeHeight( -1.00 )
		while( 1 == self.scribus.textOverflows(self.name)): self.resizeHeight(  0.10 )
		while( 0 == self.scribus.textOverflows(self.name)): self.resizeHeight( -0.01 )
		self.resizeHeight( 0.01 )

# textOverflows(frame)
# 0 ==     all text is visible
# 1 == not all text is visible

	def adjustHeightToText(self):
		if 0 == self.scribus.textOverflows(self.name):
			self.frameShrink()
		else:
			self.frameEnlarge()

	def logTextInfo(self,overflow,spacing,ds):
		print("overflow:",overflow,"lineSpacing:",spacing,'pt  ds:',ds,' pt')

	def ajdustLineSpacingToHeight(self):
		print("ajdustLineSpacingToHeight: ",self.name,self.h)
		self.scribus.sizeObject(self.w,self.h, self.name)
		spacing  = self.scribus.getLineSpacing(self.name)
		overflow = self.scribus.textOverflows( self.name)
		if overflow == 1:
			ds=-0.1 ; wo=1
		else:
			ds= 0.1 ; wo=0
		self.logTextInfo(overflow,spacing,ds)
		while overflow == wo :
			spacing+=ds; self.scribus.setLineSpacing( spacing , self.name )
			overflow =   self.scribus.textOverflows(self.name); self.logTextInfo(overflow,spacing,ds)
		spacing-=ds; ds = ds/10.0; overflow = wo
		while overflow == wo :
			spacing+=ds; self.scribus.setLineSpacing( spacing , self.name )
			overflow =   self.scribus.textOverflows(self.name); self.logTextInfo(overflow,spacing,ds)
		if wo == 1: return
		spacing-=ds
		self.scribus.setLineSpacing( spacing , self.name )
		overflow = self.scribus.textOverflows( self.name ); self.logTextInfo(overflow,spacing,ds)

	def getInfo(self):
		x , y = self.scribus.getPosition(self.name)
		w , h = self.scribus.getSize(self.name)
		lineSpacing   = self.scribus.getLineSpacing(self.name)
		textOverflows = self.scribus.textOverflows(self.name)
		nl="\n"
		t =   "getPosition()"+nl+nl+"    x:   "+str(x)+" mm"+nl+"    y:   "+str(y)+" mm"+nl+nl
		t+=       "getSize()"+nl+nl+"    w:   "+str(w)+" mm"+nl+"    h:   "+str(h)+" mm"+nl+nl
		t+="getLineSpacing()"+nl+nl+"    "     +str(lineSpacing)+" pt"+nl+nl
		t+= "textOverflows()"+nl+nl+"    "     +str(textOverflows)    +nl
		return t

	def getPageInfo(self):
		width , height                  = self.scribus.getPageSize()
		mLeft , mRight , mTop , mBottom = self.scribus.getPageMargins()
		nl="\n"
		t ="    PAGE:"+nl+nl
		t+="getPageSize()"+nl+nl
		t+="    width:   " +str(width) +" mm"+nl
		t+="    height:   "+str(height)+" mm"+nl+nl
		t+="getPageMargins()"+nl+nl
		t+="    left:   "  +str(mLeft)  +" mm"+nl
		t+="    right:   " +str(mRight) +" mm"+nl
		t+="    top:   "   +str(mTop)   +" mm"+nl
		t+="    bottom:   "+str(mBottom)+" mm"
		return t

